# SULIS EA

# PROPERTY MANAGEMENT SYSTEM (PMS)


**USER MANUAL**  
**Version: 1.0**  
**Last Updated: February 2025**


---



## Table of Contents
- [INTRODUCTION](#introduction)
- [1. SYSTEM ACCESS & LOGIN](#1-system-access--login)
- [2. DASHBOARD](#2-dashboard)
- [3. PROPERTY OPERATIONS](#3-property-operations)
  - [3.1 All Properties](#31-all-properties)
- [4. CUSTOMERS / TENANTS](#4-customers--tenants)
- [5. METER & BILLING SETUP](#5-meter--billing-setup)
  - [5.1 Billing Periods](#51-billing-periods)
  - [5.2 Meter Readings](#52-meter-readings)
- [6. BILLING & INVOICING](#6-billing--invoicing)
  - [6.1 KPLC Invoices](#61-kplc-invoices)
  - [6.2 Process Utility Bills](#62-process-utility-bills)
  - [6.3 Process Rent Bills](#63-process-rent-bills)
  - [6.4 View All Invoices](#64-view-all-invoices)
- [7. FINANCIAL OPERATIONS](#7-financial-operations)
  - [7.1 Payment Details](#71-payment-details)
- [8. REPORTS](#8-reports)
  - [8.1 Reports Dashboard](#81-reports-dashboard)
  - [8.2 Financial Report](#82-financial-report)
  - [8.3 Occupancy Report](#83-occupancy-report)
  - [8.4 Rent Roll Report](#84-rent-roll-report)
  - [8.5 Bill Display & Bill Summary](#85-bill-display--bill-summary)
- [9. SETTINGS](#9-settings)
- [END OF USER MANUAL](#end-of-user-manual)

---

## INTRODUCTION
The Property Management System (PMS) is a web-based application designed to help property managers efficiently manage properties, tenants, billing, utilities, payments, and reporting.

This user manual provides step-by-step guidance on how to use each feature of the system.

## 1. SYSTEM ACCESS & LOGIN

### Purpose
Allows authorized users to securely access the system.

### Steps
1. Open the PMS web application in your browser.
2. Enter your username and password.
3. Complete multi-factor authentication if prompted.
4. Click Login to access the dashboard.

📸 Screenshot : Login Screen

## 2. DASHBOARD

### Purpose
Provides an overview of system activities and quick access to major modules.

### Features
- Total properties
- Total Utilities Bills
- Payments summary

### Steps
1. Log in to the system.
2. The dashboard loads automatically.
3. Review displayed metrics and alerts.
4. Use quick links to navigate to modules.

📸 Screenshot : Dashboard Overview

## 3. PROPERTY OPERATIONS

### 3.1 All Properties

### Purpose
Manage all properties registered in the system.

### Steps
1. Click Property Operations on the sidebar.
2. Select All Properties.
3. Click Add Property.
4. Enter property details (name, location, type).
5. Click Save.

📸 Screenshot : All Properties Screen

📸 Screenshot : Manage Property

📸 Screenshot : Add New Property

📸 Screenshot : View Units

📸 Screenshot : Add New Unit

📸 Screenshot : Assign Customer to a Unit

## 4. CUSTOMERS / TENANTS

### Purpose
Manage tenant records and their assigned units.

### Steps
1. Click Customers / Tenants from the sidebar.
2. Click Add Tenant.
3. Enter tenant details (name, contacts, ID).
4. Upload tenant documents.
5. Assign tenant to a unit.
6. Save the tenant record.

📸 Screenshot : Customer Management Screen

📸 Screenshot : Add New Customer

📸 Screenshot : Edit Customer

## 5. METER & BILLING SETUP

### 5.1 Billing Periods

### Purpose
Define billing cycles for rent and utilities.

### Steps
1. Navigate to Meter & Billing Setup.
2. Click Billing Periods.
3. Select Add Billing Period.
4. Enter start and end dates.
5. Save the billing period.

📸 Screenshot: Billing Period Setup

### 5.2 Meter Readings

### Purpose
Record electricity and water consumption.

### Steps
1. Navigate to Meter & Billing Setup → Meter Readings.
2. Select property and unit.
3. Enter current meter readings.
4. Save readings.

📸 Screenshot: Meter Readings Screen

## 6. BILLING & INVOICING

### 6.1 KPLC Invoices

### Purpose
Manage electricity invoices from KPLC.

### Steps
1. Click Billing & Invoicing.
2. Select KPLC Invoices.
3. Upload or import invoice data.
4. Verify consumption and charges.
5. Approve invoices.

📸 Screenshot : KPLC Invoice creation

### 6.2 Process Utility Bills

### Purpose
Generate utility bills for tenants.

### Steps
1. Click Process Utility Bills.
2. Select billing period.
3. Generate utility bills.
4. Confirm processing.

📸 Screenshot : Utility Billing Screen

### 6.3 Process Rent Bills

### Purpose
Generate monthly rent invoices.

### Steps
1. Click Process Rent Bills.
2. Select billing period.
3. Generate rent invoices.
4. Review and confirm.

📸 Screenshot : Rent Billing Screen

### 6.4 View All Invoices

### Purpose
View, filter, and download invoices.

### Steps
1. Click View All Invoices.
2. Filter invoices by tenant, date, or status.
3. View or download invoice.

📸 Screenshot : Invoice List Screen

## 7. FINANCIAL OPERATIONS

### 7.1 Payment Details

### Purpose
Record and track tenant payments.

### Steps
1. Click Financial Operations.
2. Select Payment Details.
3. Click Add Payment.
4. Enter payment method and amount.
5. Allocate payment to invoices.
6. Generate receipt.

📸 Screenshot : Payment Details Screen

📸 Screenshot : Record New Payment

📸 Screenshot : View/Print/download payment receipt

## 8. REPORTS

### 8.1 Reports Dashboard

### Purpose
Access all system reports.

### Steps
1. Click Reports.
2. Select Reports Dashboard.
3. Choose report type.

📸 Screenshot : Reports Dashboard

### 8.2 Financial Report

### Purpose
View income and expense summaries.

### Steps
1. Click Financial Report.
2. Select reporting period.
3. View financial data.
4. Export to PDF or Excel.

📸 Screenshot : Financial Report

📸 Screenshot : Payment information

### 8.3 Occupancy Report

### Purpose
Monitor property occupancy levels.

### Steps
1. Click Occupancy Report.
2. Select property.
3. View occupancy statistics.

📸 Screenshot : Occupancy Report

### 8.4 Rent Roll Report

### Purpose
Track rent collection and arrears.

### Steps
1. Click Rent Roll Report.
2. Select billing period.
3. Review rent collections.

📸 Screenshot : Rent Roll Report

### 8.5 Bill Display & Bill Summary

### Purpose
View detailed and summarized billing information.

### Steps
1. Click Bill Display or Bill Summary.
2. Select billing period.
3. View totals and tax calculations.
4. Export report.

📸 Screenshot : Bill Display Screen

📸 Screenshot : Bill Summary Screen

## 9. SETTINGS

### Purpose
Configure system-wide settings.

### Steps
1. Click Settings.
2. Update company profile details.
3. Configure tax rates and billing rules.
4. Manage sms templates and notifications.
5. Save settings.

📸 Screenshot : Settings Screen

📸 Screenshot : Add SMS template

📸 Screenshot : Edit SMS

📸 Screenshot : SMS overview details

---

## END OF USER MANUAL
