<?php

namespace App\Http\Controllers;

use App\Models\Tenancy;
use App\Models\TenancyStatus;
use Illuminate\Http\Request;

class TenancyController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $tenancies = Tenancy::with(['status'])->latest()->paginate(10);
        return view('tenancy.index', compact('tenancies'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        $statuses = TenancyStatus::all();
        $customers = \App\Models\Customer::all();
        $units = \App\Models\ProUnit::all();
        $companies = \App\Models\Company::all();
        $services = \App\Models\PropService::all()->pluck('ServiceName', 'ServiceID');
        
        return view('tenancy.create', compact('statuses', 'customers', 'units', 'companies', 'services'));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $validated = $request->validate([
            'property_id' => 'required|exists:properties,id',
            'tenant_id' => 'required|exists:tenants,id',
            'start_date' => 'required|date',
            'end_date' => 'required|date|after:start_date',
            'monthly_rent' => 'required|numeric|min:0',
            'deposit' => 'required|numeric|min:0',
            'status_id' => 'required|exists:tenancy_statuses,id',
        ]);

        Tenancy::create($validated);

        return redirect()->route('tenancy.index')
            ->with('success', 'Tenancy created successfully.');
    }

    /**
     * Display the specified resource.
     */
    public function show(Tenancy $tenancy)
    {
        return view('tenancy.show', compact('tenancy'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Tenancy $tenancy)
    {
        $statuses = TenancyStatus::all();
        return view('tenancy.edit', compact('tenancy', 'statuses'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Tenancy $tenancy)
    {
        $validated = $request->validate([
            'property_id' => 'required|exists:properties,id',
            'tenant_id' => 'required|exists:tenants,id',
            'start_date' => 'required|date',
            'end_date' => 'required|date|after:start_date',
            'monthly_rent' => 'required|numeric|min:0',
            'deposit' => 'required|numeric|min:0',
            'status_id' => 'required|exists:tenancy_statuses,id',
        ]);

        $tenancy->update($validated);

        return redirect()->route('tenancy.index')
            ->with('success', 'Tenancy updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Tenancy $tenancy)
    {
        $tenancy->delete();

        return redirect()->route('tenancy.index')
            ->with('success', 'Tenancy deleted successfully');
    }
}