<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Auth;
use Illuminate\Validation\Rule;

class ProcessBillsRequest extends FormRequest
{
    public function authorize(): bool
    {
        return Auth::check();
    }

    public function rules(): array
    {
         // Get the current user's company ID from session
            $companyID = session('company_id');

        return [
            'bulk_invoices' => ['required', 'array', 'min:1'],
            'bulk_invoices.*' => [
                'integer',
                Rule::exists('bulkinvoice', 'BulkInvoiceID')
                    ->where(function ($query) use ($companyID) {
                        if ($companyID) {
                            $query->where('CompanyID', $companyID);
                        }
                    }),
            ],
            'billing_period' => ['required', 'string', 'size:6'],
            'bill_date' => ['nullable', 'date'],
            'is_draft' => ['sometimes', 'boolean'],
        ];
    }
}

