<?php

namespace App\Models;
use Illuminate\Database\Eloquent\Model;

class BillDEZ extends Model
{
    protected $table = 'billdez';
    protected $primaryKey = 'BillID';
    public $incrementing = false;

    protected $fillable = [
        'BillingPeriod',
        'CustomerID',
        'BillingDate',
        'BillType',
        'DueDate',
        'TotalBill',
        'BalanceBF',
        'TotalPayments',
        'BalanceCF',
        'LastUpdateDate',
        'LastUpdateUser'
    ];

    protected $dates = ['BillingDate', 'DueDate', 'LastUpdateDate'];

    public function customer()
    {
        return $this->belongsTo(Customer::class, 'CustomerID', 'CustomerID');
    }
}