<?php

namespace App\Models;
use Illuminate\Database\Eloquent\Model;


class BillLine extends Model
{
    protected $table = 'billline';
    protected $primaryKey = ['BillID', 'BLineID'];
    public $incrementing = false;

    protected $fillable = [
        'BillID',
        'BLineID',
        'BLineDesc',
        'BLineUnits',
        'BLineUnitPrice',
        'BLineAmount',
        'BLineCategID',
        'BLineTLineID'
    ];

    public $timestamps = false;

    public function bill()
    {
        return $this->belongsTo(Bill::class, 'BillID', 'BillID');
    }

    public function tariffLine()
    {
        return $this->belongsTo(TariffLine::class, 'BLineTLineID', 'TLineID')
            ->where('CompanyID', function($query) {
                $query->select('CompanyID')
                    ->from('bill')
                    ->whereColumn('bill.BillID', 'billline.BillID')
                    ->limit(1);
            });
    }
}