<?php

namespace App\Models;
use Illuminate\Database\Eloquent\Model;

class BillLine2 extends Model
{
    protected $table = 'billline2';
    protected $primaryKey = ['BillID', 'BLineID'];
    public $incrementing = false;

    protected $fillable = [
        'BillID',
        'BLineID',
        'BLineDesc',
        'BLineUnits',
        'BLineUnitPrice',
        'BLineAmount',
        'BLineCategID',
        'BLineTLineID'
    ];

    public $timestamps = false;

    public function bill()
    {
        return $this->belongsTo(Bill::class, 'BillID', 'BillID');
    }
}