<?php

namespace App\Models;
use Illuminate\Database\Eloquent\Model;


class BillLineDEZ extends Model
{
    protected $table = 'billlinedez';
    protected $primaryKey = ['BillID', 'BLineID'];
    public $incrementing = false;

    protected $fillable = [
        'BillID',
        'BLineID',
        'BLineDesc',
        'BLineUnits',
        'BLineUnitPrice',
        'BLineAmount',
        'BLineCategID',
        'BLineTLineID'
    ];

    public $timestamps = false;

    public function bill()
    {
        return $this->belongsTo(BillDEZ::class, 'BillID', 'BillID');
    }
}