<?php

namespace App\Models;
use Illuminate\Database\Eloquent\Model;

class BillingService extends Model
{
    protected $table = 'billingservice';
    
    // Define composite primary keys
    protected $primaryKey = ['IDService', 'CustomerID'];
    public $incrementing = false;
    public $timestamps = false;

    protected $fillable = [
        'IDService',
        'CustomerID',
        'TotalUnits'
    ];
    
    /**
     * Get the service associated with the billing service.
     */
    public function propService()
    {
        return $this->belongsTo(PropService::class, 'IDService', 'IDService');
    }
    
    /**
     * Get the customer associated with the billing service.
     */
    public function customer()
    {
        return $this->belongsTo(Customer::class, 'CustomerID', 'CustomerID');
    }
}