<?php

namespace App\Models;

use App\Scopes\CompanyScope;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Block extends Model
{
    protected $primaryKey = 'BlockID';
    protected $table = 'blocks';
    
    protected $fillable = [
        'CompanyID',
        'PropID',
        'BlockName',
        'BlockCode',
        'Description',
        'Floors',
        'UnitsPerFloor',
        'HasLift',
        'BlockStatus'
    ];

    protected $casts = [
        'HasLift' => 'boolean',
        'Floors' => 'integer',
        'UnitsPerFloor' => 'integer'
    ];

    /**
     * Get the property that owns the block.
     */
    /**
     * The "booted" method of the model.
     *
     * @return void
     */
    protected static function booted()
    {
        static::addGlobalScope(new CompanyScope);
    }

    /**
     * Get the company that owns the block.
     */
    public function company(): BelongsTo
    {
        return $this->belongsTo(Company::class, 'CompanyID', 'CompanyID');
    }

    /**
     * Get the property that owns the block.
     */
    public function property(): BelongsTo
    {
        return $this->belongsTo(Property::class, 'PropID', 'PropID');
    }

    /**
     * Get the units for the block.
     */
    public function units(): HasMany
    {
        return $this->hasMany(ProUnit::class, 'BlockID', 'BlockID');
    }

    /**
     * Scope a query to only include active blocks.
     */
    public function scopeActive($query)
    {
        return $query->where('BlockStatus', 'Active');
    }
}
