<?php

namespace App\Models;
use Illuminate\Database\Eloquent\Model;


class BulkInvoice extends Model
{
    protected $table = 'bulkinvoice';
    protected $primaryKey = 'BulkInvoiceID';
    public $incrementing = true;
     public $timestamps = false;

    protected $fillable = [
        'CompanyID',
        'BillingPeriod',
        'ConsType',
        'PropID',
        'InvoiceNo',
        'InvoiceDate',
        'Consumption',
        'FixedAmount',
        'ConsAmount',
        'InvoiceAmount',
        'DueDate',
        'CurrentReading1',
        'PreviousReading1',
        'CurrentReading2',
        'PreviousReading2',
        'InvoiceComments'
    ];

    protected $casts = [
        'InvoiceDate' => 'date:Y-m-d',
        'DueDate' => 'date:Y-m-d',
    ];

    public function company()
    {
        return $this->belongsTo(Company::class, 'CompanyID', 'CompanyID');
    }

    public function property()
    {
        return $this->belongsTo(Property::class, 'PropID', 'PropID');
    }

    public function bills()
    {
        return $this->hasMany(Bill::class, 'BulkInvoiceID', 'BulkInvoiceID');
    }

    public function bulkInvoiceLines()
    {
        return $this->hasMany(BulkInvoiceLine::class, 'BulkInvoiceID', 'BulkInvoiceID');
    }
    // public function lines()
    // {
    //     return $this->hasMany(BulkInvoiceLine::class, 'BulkInvoiceID', 'BulkInvoiceID');
    // }
}