<?php

namespace App\Models;
use Illuminate\Database\Eloquent\Model;

class BulkInvoiceLine extends Model
{
    protected $table = 'bulkinvoiceline';
    protected $primaryKey = ['BulkInvoiceID', 'BulkCategID', 'BulkLineID'];
    public $incrementing = false;
     public $timestamps = false;

    protected $fillable = [
        'BulkInvoiceID',
        'BulkCategID',
        'BulkLineID',
        'BulkLineDesc',
        'BulkLineUnitPrice',
        'BulkLineAmount'
    ];

    public function bulkInvoice()
    {
        return $this->belongsTo(BulkInvoice::class, 'BulkInvoiceID', 'BulkInvoiceID');
    }
}