<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\ProUnit;

class MaintenanceRequest extends Model
{
    use HasFactory;

    protected $table = 'maintenance_requests';
    protected $primaryKey = 'request_id';

    protected $fillable = [
        'company_id',
        'property_id',
        'block_id',
        'unit_id',
        'customer_id',
        'title',
        'description',
        'category',
        'priority',
        'assigned_technician_id',
        'assigned_date',
        'status',
        'resolution_notes',
        'completed_date',
        'attachment_path',
        'created_by',
        'updated_by',
    ];

    // -------------------------
    // Relationships
    // -------------------------

    // Company
    public function company()
    {
        return $this->belongsTo(Company::class, 'company_id', 'CompanyID');
    }

    // Property
    public function property()
    {
        return $this->belongsTo(Property::class, 'property_id', 'PropID');
    }

    // Block (optional)
    public function block()
    {
        return $this->belongsTo(Block::class, 'block_id', 'BlockID');
    }

    // Unit
    public function unit()
    {
        return $this->belongsTo(ProUnit::class, 'unit_id', 'UnitID');
    }
    
    // Customer/Tenant
    public function customer()
    {
        return $this->belongsTo(\App\Models\Customer::class, 'customer_id', 'CustomerID');
    }

    // Technician assigned (User)
    public function technician()
    {
        return $this->belongsTo(User::class, 'assigned_technician_id', 'id');
    }

    // Creator of the request (could be Customer or Admin)
    public function creator()
    {
        return $this->belongsTo(User::class, 'created_by', 'id');
    }

    // Last updater
    public function updater()
    {
        return $this->belongsTo(User::class, 'updated_by', 'id');
    }
}
