<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;

class MeterReader extends Authenticatable
{
    use HasFactory, Notifiable;

    protected $table = 'meter_readers';

    protected $fillable = [
        'username',
        'first_name',
        'last_name',
        'email',
        'phone_number',
        'password',
        'company_id',
        'PropID',
    ];

    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * Get the company that owns the meter reader.
     */
    public function company()
    {
        return $this->belongsTo(Company::class, 'company_id', 'CompanyID');
    }

    /**
     * Get the property assigned to the meter reader.
     */
    public function property()
    {
        return $this->belongsTo(\App\Models\Property::class, 'PropID', 'PropID');
    }
}
