<?php

namespace App\Models;
use Illuminate\Database\Eloquent\Model;
class MeterReading extends Model
{
    protected $table = 'meterreading';
    protected $primaryKey = 'MeterReadingID';
    public $incrementing = true;
    public $timestamps = false; // Disable automatic timestamp handling

    protected $fillable = [
        'BillingPeriod',
        'ConsType',
        'CustomerID',
        'UnitID',
        'Reading',
        'ReadingDate',
        'Consumption',
        'BaseOfBilling',
        'ReadingComments',
        'MeterNo',
        'PrvReading',
        'PrvReadingDate',
        'PrvReadingID',
        'CompanyID'
    ];

    protected $dates = ['ReadingDate', 'PrvReadingDate'];

    public function customer()
    {
        return $this->belongsTo(Customer::class, 'CustomerID', 'CustomerID');
    }

    public function unit()
    {
        return $this->belongsTo(ProUnit::class, 'UnitID', 'UnitID');
    }

    public function previousReading()
    {
        return $this->belongsTo(MeterReading::class, 'PrvReadingID', 'MeterReadingID');
    }

    public function nextReadings()
    {
        return $this->hasMany(MeterReading::class, 'PrvReadingID', 'MeterReadingID');
    }

    public function company()
    {
        return $this->belongsTo(Company::class, 'CompanyID', 'CompanyID');
    }

    public function bills()
    {
        return $this->hasMany(Bill::class, 'MeterReadingID', 'MeterReadingID');
    }
}