<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Payment extends Model
{
    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    public $timestamps = false;

    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'payment';

    /**
     * The primary key for the model.
     *
     * @var string
     */
    protected $primaryKey = 'PaymentID';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'CustomerID',
        'PaymentDate',
        'PaymentMode',
        'ReceiptNo',
        'TotalPayment',
        'Processed',
        'LastUpdatedate',
        'LastUpdateUser'
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array
     */
    protected $casts = [
        'PaymentDate' => 'date',
        'LastUpdatedate' => 'datetime',
        'TotalPayment' => 'decimal:2',
        'Processed' => 'boolean'
    ];

    /**
     * The attributes that should be mutated to dates.
     *
     * @var array
     */
    protected $dates = [
        'PaymentDate',
        'LastUpdatedate'
    ];

    /**
     * Get the customer that owns the payment.
     */
    public function customer(): BelongsTo
    {
        return $this->belongsTo(Customer::class, 'CustomerID', 'CustomerID')
            ->select(['CustomerID', 'CustomerName', 'TenantName', 'UnitID']);
    }

    /**
     * Get the user who last updated the payment.
     */
    public function receivedBy(): BelongsTo
    {
        return $this->belongsTo(User::class, 'LastUpdateUser', 'id');
    }

    /**
     * Get the unit through customer.
     */
    public function unit()
    {
        return $this->hasOneThrough(
            ProUnit::class,
            Customer::class,
            'CustomerID',  // Foreign key on Customer table
            'UnitID',      // Foreign key on ProUnit table
            'CustomerID',  // Local key on Payment table
            'UnitID'       // Local key on Customer table
        );
    }

    /**
     * Get the bill associated with the payment.
     */
    public function bill()
    {
        return $this->belongsTo(RentServiceBill::class, 'BillNo', 'BillID');
    }
}