<?php

namespace App\Models;
use Illuminate\Database\Eloquent\Model;


class PropService extends Model
{
    protected $table = 'propservice';
    protected $primaryKey = 'IDService';
    public $incrementing = true;
    public $timestamps = false;

    protected $fillable = [
        'ServiceName',
        'Description',
        'Price',
        'NoMonthPerYear',
        'CompanyID',
        'PropID'
    ];

    /**
     * Get the company that owns the service.
     */
    public function company()
    {
        return $this->belongsTo(Company::class, 'CompanyID', 'CompanyID');
    }

    /**
     * Get the property that owns the service.
     */
    public function property()
    {
        return $this->belongsTo(Property::class, 'PropID', 'PropID');
    }

    /**
     * The customers that belong to the property service.
     */
    public function customers()
    {
        return $this->belongsToMany(Customer::class, 'customer_prop_service', 'IDService', 'CustomerID')
            ->withPivot('Price', 'StartDate', 'EndDate', 'IsActive', 'Notes')
            ->withTimestamps();
    }
}