<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class RentServiceBill extends Model
{
    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'rentservicebill';

    /**
     * The primary key for the model.
     *
     * @var string
     */
    protected $primaryKey = 'BillID';

    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    public $timestamps = false;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'BillID',
        'CompanyID',
        'CustomerID',
        'UnitID',
        'BillingPeriod',
        'BillingDate',
        'DueDate',
        'TotalAmount',
        'BillStatus',
        'CreatedBy',
        'PreviousBalance',
        'CurrentCharges',
        'TotalPayable',
        'CreatedAt'
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array
     */
    protected $casts = [
        'BillingDate' => 'date',
        'DueDate' => 'date',
        'TotalAmount' => 'decimal:2',
        'PreviousBalance' => 'decimal:2',
        'CurrentCharges' => 'decimal:2',
        'TotalPayable' => 'decimal:2',
        'CreatedAt' => 'datetime'
    ];

    /**
     * Get the customer that owns the rent service bill.
     */
    public function customer(): BelongsTo
    {
        return $this->belongsTo(\App\Models\Customer::class, 'CustomerID', 'CustomerID');
    }

    /**
     * Get the unit that owns the rent service bill.
     */
    public function unit(): BelongsTo
    {
        return $this->belongsTo(\App\Models\ProUnit::class, 'UnitID', 'UnitID');
    }

    /**
     * Get the line items for the rent service bill.
     */
    public function lines(): HasMany
    {
        return $this->hasMany(\App\Models\RentServiceBillLine::class, 'BillID', 'BillID');
    }

    /**
     * Get the payments for the rent service bill through the customer.
     * This uses CustomerID as the common field between RentServiceBill and Payment tables.
     */
    public function payments()
    {
        return $this->hasMany(\App\Models\Payment::class, 'CustomerID', 'CustomerID');
    }
}
