<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class RentServiceBillLine extends Model
{
    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'rentservicebillline';

    /**
     * The primary key for the model.
     *
     * @var string
     */
    protected $primaryKey = 'BillLineID';

    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    public $timestamps = false;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'BillID',
        'LineType',
        'ItemID',
        'ItemName',
        'Units',
        'UnitPrice',
        'LineAmount',
        'CreatedAt'
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array
     */
    protected $casts = [
        'Units' => 'decimal:2',
        'UnitPrice' => 'decimal:2',
        'LineAmount' => 'decimal:2',
        'CreatedAt' => 'datetime'
    ];

    /**
     * Get the bill that owns this line item.
     */
    public function bill(): BelongsTo
    {
        return $this->belongsTo(RentServiceBill::class, 'BillID', 'BillID');
    }
}
