<?php

namespace App\Models;
use Illuminate\Database\Eloquent\Model;

class TariffCategory extends Model
{
    protected $table = 'tariffcategory';
    protected $primaryKey = 'TCID';
    public $incrementing = true;

    protected $fillable = [
        'CategoryName',
        'Description',
        'IsActive',
        'CreatedBy',
        'CreatedDate',
        'UpdatedBy',
        'UpdatedDate'
    ];

    protected $dates = ['CreatedDate', 'UpdatedDate'];

    public function tariffLines()
    {
        return $this->hasMany(TariffLine::class, 'TCID', 'TCID');
    }
}