<?php

namespace App\Models;
use Illuminate\Database\Eloquent\Model;

class TariffLine extends Model
{
    protected $table = 'tariffline';
    protected $primaryKey = ['TCID', 'TLineID'];
    public $incrementing = false;

    protected $fillable = [
        'TCID',
        'TLineID',
        'TLineDesc',
        'TLineFrom',
        'TLineTo',
        'TLineRate',
        'TLineAmount',
        'IsActive',
        'CreatedBy',
        'CreatedDate'
    ];

    protected $dates = ['CreatedDate'];

    public function category()
    {
        return $this->belongsTo(TariffCategory::class, 'TCID', 'TCID');
    }
}