<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class TmpMeterReading extends Model
{
    protected $table = 'tmp_meterreading';
    protected $primaryKey = 'MeterReadingID';
    public $incrementing = true;
    public $timestamps = false;

    protected $fillable = [
        'BillingPeriod',
        'ConsType',
        'CustomerID',
        'UnitID',
        'PropID',
        'Reading',
        'ReadingDate',
        'MeterNo',
        'ReadingComments',
        'CompanyID',
        'PrvReading',
        'PrvReadingDate',
        'PrvReadingID',
        'ImagePath'
    ];

    protected $dates = ['ReadingDate', 'PrvReadingDate'];

    public function customer()
    {
        return $this->belongsTo(Customer::class, 'CustomerID', 'CustomerID');
    }

    public function unit()
    {
        return $this->belongsTo(ProUnit::class, 'UnitID', 'UnitID')
            ->select('UnitID', 'UnitIdentity', 'PropID'); // Use 'UnitIdentity' column as 'UnitName'
    }
}
