<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('company', function (Blueprint $table) {
            $table->id('CompanyID');
            $table->string('CompanyName', 50);
            $table->string('Address1', 100)->nullable();
            $table->string('Address2', 100)->nullable();
            $table->string('TelNo', 100)->nullable();
            $table->string('Email', 200)->nullable();
            $table->string('ContactPerson', 100)->nullable();
            $table->string('CompanyLogo')->nullable();
            $table->string('LastUpdatedBy', 20)->default(DB::raw('CURRENT_USER()'));
            $table->dateTime('LastUpdatedOn')->useCurrent();
            $table->engine = 'InnoDB';
        });
    }

    public function down()
    {
        Schema::dropIfExists('company');
    }
};