<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('tblTaxes', function (Blueprint $table) {
            $table->string('TaxName', 50);
            $table->decimal('TaxPercentage', 19, 4);
            $table->char('PrintingChar', 3);
            $table->char('AccountNo', 5)->nullable();
            $table->smallIncrements('tID');
        });
    }

    public function down()
    {
        Schema::dropIfExists('tblTaxes');
    }
};