<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('property', function (Blueprint $table) {
           $table->id('PropID');
            $table->string('PropName', 60);
            $table->string('PropDesc', 100);
            $table->string('BillPeriodicity', 50);
            $table->string('City', 50);
            $table->string('PropertyType', 50);
            $table->integer('NoMonthPerYear');
            $table->string('WMeterNo', 20)->nullable();
            $table->string('EMeterNo', 20)->nullable();
            $table->unsignedBigInteger('CompanyID');
            $table->foreign('CompanyID')->references('CompanyID')->on('company')->onDelete('cascade');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('property');
    }
};
