<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;
use Illuminate\Database\QueryException;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('propservice', function (Blueprint $table) {
            $table->id('IDService');
            $table->string('ServiceName', 50);
            $table->string('Description', 100)->nullable();
            $table->decimal('Price', 19, 4);
            $table->integer('NoMonthPerYear');
            $table->unsignedBigInteger('CompanyID');
             $table->unsignedBigInteger('PropID');
            $table->foreign('PropID')->references('PropID')->on('property')->onDelete('cascade');
            
            // Enhanced fields
            $table->unsignedInteger('BillingFrequencyID')->default(1);
            $table->boolean('IsRecurring')->default(true);
            $table->boolean('IsTaxable')->default(true);
            $table->string('ServiceType', 50)->default('general');

            $table->foreign('CompanyID')->references('CompanyID')->on('company')->onDelete('cascade');
            
// We'll add the foreign key in a separate step after ensuring the table exists
        });
        
        // Add the foreign key to billing_frequencies if the table exists
        if (Schema::hasTable('billing_frequencies')) {
            Schema::table('propservice', function (Blueprint $table) {
                $table->foreign('BillingFrequencyID')
                      ->references('BillingFrequencyID')
                      ->on('billing_frequencies')
                      ->onDelete('restrict');
            });
        }
        
        // The customer_prop_service table is created in a separate migration file
    }

    public function down(): void
    {
        Schema::dropIfExists('propservice');
    }
};
