<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('prounits', function (Blueprint $table) {
            $table->id('UnitID');
            $table->unsignedBigInteger('PropID');
             $table->unsignedBigInteger('BlockID')->nullable();
            $table->string('UnitIdentity', 20);
            $table->string('BlockNo', 20)->nullable();
            $table->string('FloorNo', 20)->nullable();
            $table->string('DoorNo', 20)->nullable();
            $table->string('UnitDesc', 100)->nullable();

            $table->decimal('EFixedCharge', 19, 4)->default(0);
            $table->decimal('WFixedCharge', 19, 4)->default(0);
            $table->decimal('MonthlyRent', 19, 4)->default(0);

            $table->string('WMeterNo', 20)->nullable();
            $table->string('EMeterNo', 20)->nullable();

            $table->integer('WLastReading')->default(0);
            $table->integer('ELastReading')->default(0);
            $table->boolean('UnitActive')->default(true);
            $table->integer('WMaxReading')->default(9999);
            $table->integer('EMaxReading')->default(9999);

            $table->string('OccupationStatus', 30);

            $table->foreign('PropID')->references('PropID')->on('property')->onDelete('cascade');
             $table->unsignedBigInteger('CompanyID');
            $table->foreign('CompanyID')->references('CompanyID')->on('company')->onDelete('cascade');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('prounits');
    }
};
