<?php 
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('customer', function (Blueprint $table) {
            $table->id('CustomerID');
            $table->unsignedBigInteger('UnitID')->nullable();

            $table->string('CustomerName', 100);
            $table->string('Address1', 60);
            $table->string('Address2', 60)->nullable();
            $table->string('TelNo', 60)->nullable();
            $table->string('Email', 200)->nullable();
             $table->string('CustomerEmail', 200)->nullable();
            $table->string('AccountNo', 20);

            $table->date('ContractDate')->nullable();

            $table->decimal('Deposit', 19, 4)->nullable();
            $table->date('DepositDate')->nullable();

            $table->char('AccountStatus', 1)->default('I');

            $table->string('WMeterNo', 20)->nullable();
            $table->string('EMeterNo', 20)->nullable();

            $table->integer('WInitialReading')->nullable();
            $table->integer('EInitialReading')->nullable();

            $table->integer('WAvgCons')->nullable();
            $table->integer('EAvgCons')->nullable();

            $table->decimal('AccountBalance', 19, 4)->nullable();
            $table->decimal('TotalDebit', 19, 4)->nullable();
            $table->decimal('TotalCredit', 19, 4)->nullable();

            $table->string('AccountType', 20)->nullable();
            $table->string('AccountFileName', 40);

            $table->string('AddressLine', 200)->nullable();
            $table->string('Address3', 60)->nullable();
            $table->string('ClientCode', 100)->nullable();
            $table->string('TenantName', 50)->nullable();
            $table->unsignedBigInteger('CompanyID');
            $table->foreign('CompanyID')->references('CompanyID')->on('company')->onDelete('cascade');
             $table->unsignedBigInteger('PropID')->nullable();
            $table->foreign('PropID')->references('PropID')->on('property')->onDelete('cascade');
            // Foreign Key
            $table->foreign('UnitID')
                  ->references('UnitID')
                  ->on('prounits')
                  ->onDelete('cascade');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('customer');
    }
};
