<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('tariffcategory', function (Blueprint $table) {
            $table->unsignedBigInteger('CompanyID');
            $table->char('CategoryID', 3);

            $table->string('TariffCatName', 60);
            $table->string('Class', 10);
            $table->string('BillingModeName', 60);
            $table->string('ConsType', 6)->nullable();

            $table->dateTime('LastUpdateDate')->useCurrent();
            $table->string('LastUpdateUser', 20)->default('system');

            $table->primary(['CompanyID', 'CategoryID']);
            $table->foreign('CompanyID')->references('CompanyID')->on('company')->onDelete('cascade');

        });
    }

    public function down(): void
    {
        Schema::dropIfExists('tariffcategory');
    }
};
