<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('tariffline', function (Blueprint $table) {
            $table->unsignedBigInteger('CompanyID');
            $table->char('CategoryID', 3);
            $table->char('TLineID', 3);

            $table->string('TLineName', 60);
            $table->string('TLineDescription', 60)->nullable();
            $table->char('TLineBillingMode', 3);
            $table->smallInteger('TLineMinConsumption')->nullable();
            $table->smallInteger('TLineMaxConsumption')->nullable();
            $table->decimal('TLinePricePerUnit', 10, 4);
            $table->char('TLineCalcMethod', 3)->nullable();
            $table->string('TLineConsType', 6)->nullable();
            $table->string('TLineAccountNo', 5);
            $table->unsignedSmallInteger('TLineTaxID')->nullable();
            $table->smallInteger('TLinePeriodicity')->nullable();
            $table->smallInteger('TLinePriority')->nullable();

            $table->dateTime('LastUpdateDate')->useCurrent();
            $table->string('LastUpdateUser', 10)->default('system');

            $table->primary(['CompanyID', 'CategoryID', 'TLineID']);

            // Foreign Keys
            $table->foreign('CompanyID')
                  ->references('CompanyID')
                  ->on('company')
                  ->onDelete('cascade');
                  
            $table->foreign(['CompanyID', 'CategoryID'])
                  ->references(['CompanyID', 'CategoryID'])
                  ->on('tariffcategory')
                  ->onDelete('cascade');
                  
            // Temporarily disable foreign key checks for these tables as they might not exist yet
            // or have different structures
            
            // $table->foreign('TLineCalcMethod')
            //       ->references('tID')
            //       ->on('tblcalmethod');
                  
            // $table->foreign('TLineConsType')
            //       ->references('tID')
            //       ->on('tblconstype');
                  
            // $table->foreign('TLineTaxID')
            //       ->references('tID')
            //       ->on('tbltaxes');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('tariffline');
    }
};
