<?php 
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('meterreading', function (Blueprint $table) {
            $table->id('MeterReadingID');

            $table->integer('BillingPeriod');
            $table->string('ConsType', 6);
            $table->unsignedBigInteger('CustomerID');
            $table->unsignedBigInteger('UnitID');

            $table->integer('Reading')->nullable();
            $table->date('ReadingDate')->nullable();
            $table->integer('Consumption')->nullable();

            $table->string('BaseOfBilling', 20)->nullable();
            $table->string('ReadingComments', 100)->nullable();
            $table->string('MeterNo', 20)->nullable();

            $table->integer('PrvReading')->nullable();
            $table->date('PrvReadingDate')->nullable();
            $table->unsignedInteger('PrvReadingID')->nullable();

            $table->string('ImagePath')->nullable();
            $table->unsignedBigInteger('PropID')->nullable;
            $table->unsignedBigInteger('CompanyID');

            // Foreign Keys - temporarily disable problematic foreign keys
            $table->foreign('CustomerID')
                  ->references('CustomerID')
                  ->on('customer')
                  ->onDelete('cascade');

            // Self-referencing foreign key - add it after the table is created
            // $table->foreign('PrvReadingID')
            //       ->references('MeterReadingID')
            //       ->on('meterreading')
            //       ->onDelete('set null');

            // Temporarily disabled due to potential issues with tblconstype
            // $table->foreign('ConsType')
            //       ->references('tID')
            //       ->on('tblconstype');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('meterreading');
    }
};
