<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('billingservice', function (Blueprint $table) {
            // Columns
            $table->unsignedBigInteger('IDService');
            $table->unsignedBigInteger('CustomerID');
            $table->integer('TotalUnits');

            // Composite Primary Key
            $table->primary(['IDService', 'CustomerID']);

            // Optional Indexes
            $table->index('CustomerID');
            $table->index('IDService');

            // Foreign Keys
            $table->foreign('CustomerID')
                  ->references('CustomerID')
                  ->on('customer')
                  ->onDelete('cascade');

            $table->foreign('IDService')
                  ->references('IDService')
                  ->on('propservice')
                  ->onDelete('cascade');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('billingservice');
    }
};
