<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('billline', function (Blueprint $table) {
            // Columns
            $table->unsignedInteger('BillID');
            $table->integer('BLineID');
            $table->string('BLineDesc', 60);
            $table->decimal('BLineUnits', 19, 4);
            $table->decimal('BLineUnitPrice', 19, 4);
            $table->decimal('BLineAmount', 19, 4)->default(0);
            $table->char('BLineCategID', 3);
            $table->char('BLineTLineID', 3);

            // Composite Primary Key
            $table->primary(['BillID', 'BLineID']);

            // Index
            $table->index('BillID');

            // Foreign Key to Bill table
            $table->foreign('BillID')
                  ->references('BillID')
                  ->on('bill')
                  ->onDelete('cascade');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('billline');
    }
};
