<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('payment', function (Blueprint $table) {
            $table->id('PaymentID');
            $table->unsignedBigInteger('CustomerID');
            $table->date('PaymentDate')->nullable();
            $table->string('PaymentMode', 30)->nullable();
            $table->string('ReceiptNo', 15)->nullable();
            $table->decimal('TotalPayment', 19, 4)->default(0);
            $table->char('Processed', 1)->default('N');
            $table->dateTime('LastUpdatedate')->useCurrent();
            $table->string('LastUpdateUser', 10)->default('system');

            $table->foreign('CustomerID')
                  ->references('CustomerID')
                  ->on('customer')
                  ->onDelete('cascade');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('payment');
    }
};
