<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('BillLineDEZ', function (Blueprint $table) {

            // Columns
            $table->integer('BillID');
            $table->integer('BLineID');
            $table->string('BLineDesc', 60);
            $table->decimal('BLineUnits', 19, 4);
            $table->decimal('BLineUnitPrice', 19, 4);
            $table->decimal('BLineAmount', 19, 4)->default(0); // default like others
            $table->char('BLineCategID', 3);
            $table->char('BLineTLineID', 3);

            // Composite Primary Key
            $table->primary(['BillID', 'BLineID']);

            // Index for faster queries
            $table->index('BillID');

            // Optional foreign key if linking to BillDEZ
            $table->foreign('BillID')
                  ->references('BillID')
                  ->on('BillDEZ')
                  ->onDelete('cascade');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('BillLineDEZ');
    }
};
