<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('tmp_bulkinvoiceline', function (Blueprint $table) {
            $table->increments('tblID');
            
            $table->unsignedBigInteger('BulkInvoiceID');
            $table->char('BulkCategID', 3);
            $table->char('BulkLineID', 3);
            $table->string('BulkLineDesc', 60);
            $table->decimal('BulkLineUnitPrice', 10, 4);
            $table->decimal('BulkLineAmount', 19, 4);
            $table->char('TableOwner', 9);

            // Foreign key
            $table->foreign('BulkInvoiceID')
                  ->references('BulkInvoiceID')
                  ->on('bulkinvoice')
                  ->onDelete('cascade');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('tmp_bulkinvoiceline');
    }
};
