<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('tmp_meterreading', function (Blueprint $table) {

            $table->integer('MeterReadingID')->primary();

            $table->integer('BillingPeriod');
            $table->string('ConsType', 6);
            $table->integer('CustomerID');
            $table->integer('UnitID');
            $table->string('MeterNo',20)->nullable;

            $table->integer('Reading')->nullable();
            $table->date('ReadingDate')->nullable();
            $table->integer('Consumption')->nullable();

            $table->string('BaseOfBilling', 20)->nullable();

            $table->string('ReadingComments',100);
            $table->integer('PrvReading')->nullable();
            $table->date('PrvReadingDate')->nullable();
            $table->integer('PrvReadingID')->nullable();

            $table->string('ImagePath')->nullable();
         $table->unsignedBigInteger('PropID')->nullable;
            $table->integer('CompanyID');

            // FK to Consumption Type
            $table->foreign('ConsType')
                  ->references('tID')
                  ->on('tblConsType');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('tmp_meterreading');
    }
};
