<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('bulkinvoiceline', function (Blueprint $table) {
            $table->unsignedBigInteger('BulkInvoiceID');
            $table->char('BulkCategID', 3);
            $table->char('BulkLineID', 3);
            $table->string('BulkLineDesc', 60);
            $table->decimal('BulkLineUnitPrice', 10, 4);
            $table->decimal('BulkLineAmount', 19, 4);

            // Composite primary key
            $table->primary(['BulkInvoiceID', 'BulkCategID', 'BulkLineID'], 'PK_BulkInvoiceLine');

            // Foreign key
            $table->foreign('BulkInvoiceID')
                  ->references('BulkInvoiceID')
                  ->on('bulkinvoice')
                  ->onDelete('cascade');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('bulkinvoiceline');
    }
};
