<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('unit_assignments', function (Blueprint $table) {
            $table->id();
            
            // Match the exact data type of the referenced columns
            $table->unsignedBigInteger('customer_id');  // Changed to match CUSTOMER.CustomerID (UNSIGNED INTEGER)
            $table->unsignedBigInteger('unit_id');      // Changed to match ProUnits.UnitID (assuming it's the same as CustomerID)
            
            $table->date('start_date');
            $table->date('end_date')->nullable();
            $table->enum('status', ['active', 'terminated', 'transferred'])->default('active');
            $table->text('notes')->nullable();
            $table->timestamps();

            // First, create the index
            $table->index('customer_id');
            $table->index('unit_id');
            
            // Then add the foreign key constraints with explicit column types
            $table->foreign('customer_id')
                  ->references('CustomerID')
                  ->on('CUSTOMER')
                  ->onDelete('cascade')
                  ->onUpdate('cascade');
                  
            $table->foreign('unit_id')
                  ->references('UnitID')
                  ->on('ProUnits')
                  ->onDelete('cascade')
                  ->onUpdate('cascade');

            // Add unique constraint to prevent duplicate active assignments
            $table->unique(['customer_id', 'status']);
            
            // Add comment to explain the relationship
            $table->comment('Tracks customer unit assignments with status');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('unit_assignments');
    }
};
