<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    public function up()
    {
        // Check if the company table exists
        if (Schema::hasTable('company')) {
            // Add ChequePayableTo column if it doesn't exist
            if (!Schema::hasColumn('company', 'ChequePayableTo')) {
                Schema::table('company', function (Blueprint $table) {
                    // Add the column without specifying position
                    $table->string('ChequePayableTo', 255)->nullable();
                });

                // Set default value for existing records
                if (DB::table('company')->count() > 0) {
                    DB::table('company')->update([
                        'ChequePayableTo' => 'HassConsult Real Estate Ltd - Watermark'
                    ]);
                }
            }
        }
    }

    public function down()
    {
        if (Schema::hasTable('company') && Schema::hasColumn('company', 'ChequePayableTo')) {
            Schema::table('company', function (Blueprint $table) {
                $table->dropColumn('ChequePayableTo');
            });
        }
    }
};
