<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('rentservicebill', function (Blueprint $table) {
            $table->id('BillID');
            $table->unsignedBigInteger('CompanyID');
            $table->unsignedBigInteger('CustomerID');
            $table->unsignedBigInteger('UnitID');
            $table->string('BillingPeriod', 50);
            $table->date('BillingDate');
            $table->decimal('TotalAmount', 10, 2);
            $table->string('BillStatus', 20);
            $table->timestamp('CreatedAt')->useCurrent();
            $table->unsignedBigInteger('CreatedBy');
            $table->decimal('PreviousBalance', 10, 2)->default(0);
            $table->decimal('CurrentCharges', 10, 2)->default(0);
            $table->decimal('TotalPayable', 10, 2);
            
            // Add foreign key constraints if needed
            // $table->foreign('CompanyID')->references('id')->on('companies');
            // $table->foreign('CustomerID')->references('id')->on('customers');
            // $table->foreign('UnitID')->references('id')->on('units');
            // $table->foreign('CreatedBy')->references('id')->on('users');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('rentservicebill');
    }
};
