<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('rentservicebillline', function (Blueprint $table) {
            $table->id('BillLineID');
            $table->unsignedBigInteger('BillID');
            $table->string('LineType', 50);
            $table->unsignedBigInteger('ItemID')->nullable();
            $table->string('ItemName', 255);
            $table->decimal('Units', 10, 2)->default(1);
            $table->decimal('UnitPrice', 10, 2);
            $table->decimal('LineAmount', 10, 2);
            $table->timestamp('CreatedAt')->useCurrent();
            
            // Add foreign key constraint
            // $table->foreign('BillID')->references('BillID')->on('rentservicebill')->onDelete('cascade');
            // $table->foreign('ItemID')->references('id')->on('items'); // Uncomment if you have an items table
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('rentservicebillline');
    }
};
