<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Drop functions if they exist
        DB::unprepared('DROP FUNCTION IF EXISTS fn_billing_month_ex;');
        DB::unprepared('DROP FUNCTION IF EXISTS fn_billing_month_ex2;');

        // Create fn_billing_month_ex function
        DB::unprepared("
        CREATE FUNCTION fn_billing_month_ex(bperiod CHAR(6)) 
        RETURNS VARCHAR(20)
        DETERMINISTIC
        BEGIN
            DECLARE bill_month VARCHAR(50);
            
            IF bperiod = '201407' THEN
                SET bill_month = 'Apr-Jul 2014';
            ELSEIF bperiod = '201506' THEN
                SET bill_month = 'Jan-Jun 2015';
            ELSE
                SET bill_month = CONCAT(
                    MONTHNAME(STR_TO_DATE(CONCAT(RIGHT(bperiod, 2), '/01/', LEFT(bperiod, 4)), '%m/%d/%Y')),
                    ' ',
                    LEFT(bperiod, 4)
                );
            END IF;
            
            RETURN bill_month;
        END;
        ");

        // Create fn_billing_month_ex2 function
        DB::unprepared("
        CREATE FUNCTION fn_billing_month_ex2(bperiod CHAR(6))
        RETURNS VARCHAR(20)
        DETERMINISTIC
        BEGIN
            DECLARE tmp_period VARCHAR(20);
            DECLARE tmp_period2 VARCHAR(20);
            
            SET tmp_period = fn_billing_month_ex(bperiod);
            
            IF bperiod = '201407' THEN
                SET tmp_period2 = 'Apr-Jul.14';
            ELSEIF bperiod = '201506' THEN
                SET tmp_period2 = 'Jan-Jun 2015';
            ELSE
                SET tmp_period2 = CONCAT(
                    LEFT(tmp_period, 3),
                    '.',
                    RIGHT(tmp_period, 5)
                );
            END IF;
            
            RETURN tmp_period2;
        END;
        ");

    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // Drop the functions when rolling back
        DB::unprepared('DROP FUNCTION IF EXISTS fn_billing_month_ex;');
        DB::unprepared('DROP FUNCTION IF EXISTS fn_billing_month_ex2;');

    }
};
