<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;
return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        DB::statement("CREATE OR REPLACE VIEW view_statement AS
        SELECT 
            AccountNo,
            CustomerName,
            EMeterNo AS MeterNo,
            ShopNo AS AptNo,
            BillNo,
            fn_billing_month_ex2(BillingPeriod) AS Period,
            BillingDate AS `Billing Date`,
            CurReading AS `Current Reading`,
            PrvReading AS `Previous Reading`,
            ConsumptionBilled AS `Cons (m3)`,
            BalanceBF AS `Balance B/F`,
            TotalPayments AS Payments,
            TotalBill AS `Bill Amount`,
            BalanceCF AS `Balance C/F`,
            PropName,
            AddressLine
        FROM view_bill_print;");
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        DB::statement('DROP VIEW IF EXISTS view_statement');
    }
};
