<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    public function up(): void
    {
        DB::statement("CREATE OR REPLACE VIEW VIEW_BILL_COURTS AS
SELECT 
    fn_BillingMonthEx(b.BillingPeriod) AS BillMonth,
    b.BillingPeriod,
    b.BillingDate,
    c.CustomerName,
    c.Address1 AS AddressLine,
    b.DueDate,
    p.PropName,
    b.BulkInvoiceID,
    c.Address1 AS Court,
    LEFT(c.Address3, 3) AS CourtID,
    c.ClientCode,
    SUM(b.ConsumptionBilled) AS ConsumptionBilled,
    0 AS BalanceBF,
    0 AS TotalPayments,
    SUM(b.TotalBill) AS TotalBill,
    SUM(b.TotalBill) AS BalanceCF,
    CONCAT(c.ClientCode, '_', b.BillingPeriod) AS BillNo,
    COUNT(*) AS NoOfBills,
    c.TenantName,
    c.AccountNo,
    c.EMeterNo,
    MAX(b.CurReading) AS CurrentReading,
    MAX(b.PrvReading) AS PreviousReading,
    MAX(b.CurReadingDate) AS CurrentReadingDate
FROM bill b
INNER JOIN customer c ON b.CustomerID = c.CustomerID
INNER JOIN prounits pu ON c.UnitID = pu.UnitID
INNER JOIN property p ON pu.PropID = p.PropID
GROUP BY 
    fn_BillingMonthEx(b.BillingPeriod),
    b.BillingPeriod,
    b.BillingDate,
    c.CustomerName,
    c.Address1,
    b.DueDate,
    p.PropName,
    b.BulkInvoiceID,
    LEFT(c.Address3, 3),
    c.ClientCode,
    c.TenantName,
    c.AccountNo,
    c.EMeterNo;
        ");
    }

    public function down(): void
    {
        DB::statement("DROP VIEW IF EXISTS VIEW_BILL_COURTS");
    }
};