<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;
return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        DB::statement("CREATE OR REPLACE VIEW view_bill_print2 AS
        SELECT 
            BillNo, BillMonth, BillingPeriod, BillingDate, BalanceBF, TotalBill, TotalPayments, BalanceCF, ConsumptionBilled,
            AccountNo, CustomerName, EMeterNo, DueDate, PropName, ShopNo, BulkInvoiceID,
            SUM(VATABLE) AS VATABLE,
            SUM(NONVATABLE) AS NONVATABLE,
            SUM(VATAmount) AS VATAmount,
            Address1
        FROM (
            SELECT 
                b.BillID AS BillNo,
                fn_billing_month_ex(b.BillingPeriod) AS BillMonth,
                b.BillingPeriod,
                CAST(b.BillingDate AS DATETIME) AS BillingDate,
                b.BalanceBF,
                b.TotalBill,
                b.TotalPayments,
                b.BalanceCF,
                b.ConsumptionBilled,
                c.AccountNo,
                c.CustomerName,
                c.EMeterNo,
                CAST(b.DueDate AS DATETIME) AS DueDate,
                p.PropName,
                pu.UnitIdentity AS ShopNo,
                b.BulkInvoiceID,
                CASE WHEN tl.TLineTaxID = 1 THEN bl.BLineAmount ELSE 0 END AS VATABLE,
                CASE WHEN tl.TLineTaxID IS NULL THEN bl.BLineAmount ELSE 0 END AS NONVATABLE,
                0 AS VATAmount,
                c.Address1
            FROM bill b
            JOIN customer c ON b.CustomerID = c.CustomerID
            JOIN prounits pu ON c.UnitID = pu.UnitID
            JOIN property p ON pu.PropID = p.PropID
            JOIN billline bl ON b.BillID = bl.BillID
            LEFT JOIN tariffline tl ON bl.BLineTLineID = tl.TLineID AND bl.BLineCategID = tl.CategoryID AND p.CompanyID = tl.CompanyID
            WHERE bl.BLineTLineID <> 'VAT'
            
            UNION ALL
            
            SELECT 
                b.BillID AS BillNo,
                fn_billing_month_ex(b.BillingPeriod) AS BillMonth,
                b.BillingPeriod,
                CAST(b.BillingDate AS DATETIME) AS BillingDate,
                b.BalanceBF,
                b.TotalBill,
                b.TotalPayments,
                b.BalanceCF,
                b.ConsumptionBilled,
                c.AccountNo,
                c.CustomerName,
                c.EMeterNo,
                CAST(b.DueDate AS DATETIME) AS DueDate,
                p.PropName,
                pu.UnitIdentity AS ShopNo,
                b.BulkInvoiceID,
                0 AS VATABLE,
                0 AS NONVATABLE,
                bl.BLineAmount AS VATAmount,
                c.Address1
            FROM bill b
            JOIN customer c ON b.CustomerID = c.CustomerID
            JOIN prounits pu ON c.UnitID = pu.UnitID
            JOIN property p ON pu.PropID = p.PropID
            JOIN billline bl ON b.BillID = bl.BillID
            LEFT JOIN tariffline tl ON bl.BLineTLineID = tl.TLineID AND bl.BLineCategID = tl.CategoryID AND p.CompanyID = tl.CompanyID
            WHERE bl.BLineTLineID = 'VAT'
        ) AS B
        GROUP BY BillNo, BillMonth, BillingPeriod, BillingDate, BalanceBF, TotalBill, TotalPayments, BalanceCF, ConsumptionBilled,
                 AccountNo, CustomerName, EMeterNo, DueDate, PropName, ShopNo, BulkInvoiceID, Address1;");
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        DB::statement('DROP VIEW IF EXISTS view_bill_print2');
    }
};
