<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;
return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        DB::statement("CREATE OR REPLACE VIEW view_bill_summ3 AS
        SELECT 
            fn_billing_month_ex(b.BillingPeriod) AS BillMonth,
            b.BillingPeriod,
            CONVERT(CONCAT(RIGHT(100 + bl.BLineID, 2), '. ', bl.BLineDesc) USING utf8mb4) COLLATE utf8mb4_unicode_ci AS BLineDesc,
            SUM(0 - bl.BLineAmount) AS Amount,
            b.BulkInvoiceID,
            CONVERT(CONCAT('Total Billing - ', fn_billing_month_ex(b.BillingPeriod)) USING utf8mb4) COLLATE utf8mb4_unicode_ci AS CustomerName,
            CONVERT('Kshs. ' USING utf8mb4) COLLATE utf8mb4_unicode_ci AS LineType
        FROM Bill b
        JOIN Customer c ON b.CustomerID = c.CustomerID
        JOIN BillLine bl ON b.BillID = bl.BillID
        WHERE bl.BLineID NOT BETWEEN 2 AND 6
        GROUP BY 
            fn_billing_month_ex(b.BillingPeriod),
            b.BillingPeriod,
            bl.BLineID,
            bl.BLineDesc,
            b.BulkInvoiceID,
            CONCAT('Total Billing - ', fn_billing_month_ex(b.BillingPeriod)) COLLATE utf8mb4_unicode_ci

        UNION ALL

        SELECT 
            fn_billing_month_ex(b.BillingPeriod) AS BillMonth,
            b.BillingPeriod,
            CONVERT(CONCAT(RIGHT(100 + bl.BLineID, 2), '. ', bl.BLineDesc) USING utf8mb4) COLLATE utf8mb4_unicode_ci AS BLineDesc,
            SUM(0 - bl.BLineAmount) AS Amount,
            b.BulkInvoiceID,
            CONVERT(CONCAT('Total Billing - ', fn_billing_month_ex(b.BillingPeriod)) USING utf8mb4) COLLATE utf8mb4_unicode_ci AS CustomerName,
            CONVERT('Kshs. ' USING utf8mb4) COLLATE utf8mb4_unicode_ci AS LineType
        FROM Bill b
        JOIN Customer c ON b.CustomerID = c.CustomerID
        JOIN BillLine2 bl ON b.BillID = bl.BillID
        GROUP BY 
            fn_billing_month_ex(b.BillingPeriod),
            b.BillingPeriod,
            bl.BLineID,
            bl.BLineDesc,
            b.BulkInvoiceID,
            CONCAT('Total Billing - ', fn_billing_month_ex(b.BillingPeriod)) COLLATE utf8mb4_unicode_ci

        UNION ALL

        SELECT 
            fn_billing_month_ex(b.BillingPeriod) AS BillMonth,
            b.BillingPeriod,
            CONVERT(CONCAT(RIGHT(100 + tl.TLinePriority, 2), '. ', bl.BulkLineDesc) USING utf8mb4) COLLATE utf8mb4_unicode_ci AS BLineDesc,
            bl.BulkLineAmount AS Amount,
            b.BulkInvoiceID,
            CONVERT(CONCAT('KPLC Bill ', b.InvoiceNo) USING utf8mb4) COLLATE utf8mb4_unicode_ci AS CustomerName,
            CONVERT('Kshs. ' USING utf8mb4) COLLATE utf8mb4_unicode_ci AS LineType
        FROM BulkInvoiceLine bl
        JOIN TariffLine tl ON bl.BulkCategID = tl.CategoryID AND bl.BulkLineID = tl.TLineID
        JOIN BulkInvoice b ON bl.BulkInvoiceID = b.BulkInvoiceID
        WHERE bl.BulkLineAmount <> 0
        GROUP BY 
            fn_billing_month_ex(b.BillingPeriod),
            b.BillingPeriod,
            tl.TLinePriority,
            bl.BulkLineDesc,
            bl.BulkLineAmount,
            b.BulkInvoiceID,
            b.InvoiceNo

        UNION ALL

        SELECT 
            fn_billing_month_ex(b.BillingPeriod) AS BillMonth,
            b.BillingPeriod,
            CONVERT(' Cons. (Kwh) ' USING utf8mb4) COLLATE utf8mb4_unicode_ci AS BLineDesc,
            SUM(0 - b.ConsumptionBilled) AS Amount,
            b.BulkInvoiceID,
            CONVERT(CONCAT('Total Billing - ', fn_billing_month_ex(b.BillingPeriod)) USING utf8mb4) COLLATE utf8mb4_unicode_ci AS CustomerName,
            CONVERT('Kwh ' USING utf8mb4) COLLATE utf8mb4_unicode_ci AS LineType
        FROM Bill b
        JOIN Customer c ON b.CustomerID = c.CustomerID
        GROUP BY 
            fn_billing_month_ex(b.BillingPeriod),
            b.BillingPeriod,
            b.ConsumptionBilled,
            b.BulkInvoiceID,
            CONCAT('Total Billing - ', fn_billing_month_ex(b.BillingPeriod)) COLLATE utf8mb4_unicode_ci

        UNION ALL

        SELECT 
            fn_billing_month_ex(BillingPeriod) AS BillMonth,
            BillingPeriod,
            CONVERT(' Cons. (Kwh) ' USING utf8mb4) COLLATE utf8mb4_unicode_ci AS BLineDesc,
            Consumption AS Amount,
            BulkInvoiceID,
            CONCAT('KPLC Bill ', InvoiceNo) AS CustomerName,
            CONVERT('Kwh ' USING utf8mb4) COLLATE utf8mb4_unicode_ci AS LineType
        FROM BulkInvoice
        GROUP BY 
            fn_billing_month_ex(BillingPeriod),
            BillingPeriod,
            Consumption,
            BulkInvoiceID,
            InvoiceNo;");
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        DB::statement('DROP VIEW IF EXISTS view_bill_summ3');
    }
};
