<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;
return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        DB::statement("CREATE OR REPLACE VIEW view_cust_details AS
        SELECT 
            c.CompanyID,
            c.CompanyName,
            cm.CustomerID,
            cm.CustomerName,
            cm.AccountNo,
            pu.UnitIdentity,
            cm.AccountStatus,
            CONCAT(cm.CustomerName, ' ', cm.AccountNo, ' ', pu.UnitIdentity, ' ', pu.UnitDesc, ' ', cm.AddressLine) AS CustData,
            cm.AddressLine
        FROM Customer cm
        JOIN ProUnits pu ON cm.UnitID = pu.UnitID
        JOIN Property p ON pu.PropID = p.PropID
        JOIN Company c ON p.CompanyID = c.CompanyID;");
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        DB::statement('DROP VIEW IF EXISTS view_cust_details');
    }
};
