<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;
return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        DB::statement("CREATE OR REPLACE VIEW view_new_payments AS
        SELECT * FROM (
            SELECT CustomerID, CustomerName, Email, AccountBalance
            FROM Customer
            WHERE AccountType <> 'TERMINATED'

            UNION ALL
            SELECT 0 AS CustomerID, 'Clinford Limited', 'Clinford Limited', -0.65
            UNION ALL
            SELECT 0, 'Blancos Holdings', 'Blancos Holdings', 81730.45
            UNION ALL
            SELECT 0, 'Arcon Consult', 'Arcon Consult', 27.95
            UNION ALL
            SELECT 0, 'Safari Beads', 'Safari Beads', -528.85
        ) AS C
        ORDER BY Email
        LIMIT 1000;");
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        DB::statement('DROP VIEW IF EXISTS view_new_payments');
    }
};
