<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;
return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        DB::statement("CREATE OR REPLACE VIEW view_reading_sheet AS
        SELECT 
            c.CustomerID AS ID,
            c.CustomerName AS Tenant,
            p.UnitIdentity AS ShopNo,
            c.EMeterNo AS MeterNo
        FROM Customer c
        JOIN ProUnits p ON c.UnitID = p.UnitID
        WHERE c.AccountType <> 'TERMINATED'
        ORDER BY c.Address2
        LIMIT 200;");
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        DB::statement('DROP VIEW IF EXISTS view_reading_sheet');
    }
};
