<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('BankDetails', function (Blueprint $table) {
            $table->id('BankDetailID');
            $table->unsignedBigInteger('CompanyID');
            $table->unsignedBigInteger('PropID');
            $table->string('BankName', 100);
            $table->string('AccountNumber', 50);
            $table->string('BankBranch', 50);
            $table->string('BankFullName', 100);
            $table->boolean('IsActive')->default(true);
            $table->timestamps();
            
            // Foreign key constraints
            $table->foreign('CompanyID')->references('CompanyID')->on('company');
            $table->foreign('PropID')->references('PropID')->on('property');
            
            // Add unique constraint to prevent duplicate bank accounts
            $table->unique(['CompanyID', 'PropID', 'AccountNumber'], 'IX_UK_BankDetails');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('BankDetails');
    }
};
